// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------
   float2 ViewSize;
   float Offset=3.0;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
         Texture=<RenderTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
        float4 Tex:TEXCOORD0;
        float4 Tex1:TEXCOORD1;
        float4 Tex2:TEXCOORD2;
        float4 Tex3:TEXCOORD3;
        float4 Tex4:TEXCOORD4;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos; 
        OUT.Tex.xy=(float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5;
        OUT.Tex.zw=0.0;
        OUT.Tex1.xy=OUT.Tex+float2(ViewSize.x,0.0)*Offset;
        OUT.Tex1.zw=OUT.Tex+float2(0.0,ViewSize.y)*Offset;
        OUT.Tex2.xy=OUT.Tex-float2(ViewSize.x,0.0)*Offset;
        OUT.Tex2.zw=OUT.Tex-float2(0.0,ViewSize.y)*Offset;
        OUT.Tex3.xy=OUT.Tex+float2(ViewSize.x,ViewSize.y)*Offset;
        OUT.Tex3.zw=OUT.Tex-float2(ViewSize.x,ViewSize.y)*Offset;
        OUT.Tex4.xy=OUT.Tex+float2(-ViewSize.x,ViewSize.y)*Offset;
        OUT.Tex4.zw=OUT.Tex+float2(ViewSize.x,-ViewSize.y)*Offset;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
         float2 FrameRender=tex2Dlod(RenderSampler,IN.Tex)
                           +tex2Dlod(RenderSampler,IN.Tex1.xyyy)
                           +tex2Dlod(RenderSampler,IN.Tex1.zwww)
                           +tex2Dlod(RenderSampler,IN.Tex2.xyyy)
                           +tex2Dlod(RenderSampler,IN.Tex2.zwww)
                           +tex2Dlod(RenderSampler,IN.Tex3.xyyy)
                           +tex2Dlod(RenderSampler,IN.Tex3.zwww)
                           +tex2Dlod(RenderSampler,IN.Tex4.xyyy)
                           +tex2Dlod(RenderSampler,IN.Tex4.zwww);
        FrameRender=FrameRender*0.11111111111;
	return float4(floor(FrameRender*255.0)/255.0,frac(FrameRender*255.0));
     }


//--------------
// techniques   
//--------------
    technique Blur
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
      }
      }
